# Node.js + TypeScript + MongoDB: JWT Refresh Token

In this article, you'll learn how to implement JWT Authentication with an Access and a Refresh token using Node.js, TypeScript, MongoDB, Redis, and Docker.

![Node.js + TypeScript + MongoDB: JWT Refresh Token](https://codevoweb.com/wp-content/uploads/2022/04/Node.js-TypeScript-MongoDB-JWT-Refresh-Token.webp)

## Topics Covered

- JWT Refresh Token with Node.js, TypeScript, and MongoDB Overview
- JWT Refresh Token Implementation Flow
- Generate Public and Private Keys for the Token
- Update Environment Variables in Config
- Update the Sign and Verify JWT Utility Functions
- Update the Sign Token Service Function
- Update the Login Controller
- Create a Controller to Refresh Access Token
- Create a Controller to Logout User
- Update the Authentication Routes
- Update app.ts

Read the entire article here: [https://codevoweb.com/react-node-access-refresh-tokens-authentication/](https://codevoweb.com/react-node-access-refresh-tokens-authentication/)


Articles in this series:

### 1. Node.js + TypeScript + MongoDB: JWT Authentication

[Node.js + TypeScript + MongoDB: JWT Authentication](https://codevoweb.com/node-typescript-mongodb-jwt-authentication)

### 2. Node.js + TypeScript + MongoDB: JWT Refresh Token

[Node.js + TypeScript + MongoDB: JWT Refresh Token](https://codevoweb.com/react-node-access-refresh-tokens-authentication)

### 3. Google OAuth Authentication with React.js and Node.js (No Passport)

[Google OAuth Authentication with React.js and Node.js (No Passport)](https://codevoweb.com/react-node-access-refresh-tokens-authentication)

### 4. GitHub OAuth Authentication React.js and Node.js(No Passport)

[GitHub OAuth Authentication React.js and Node.js(No Passport)](https://codevoweb.com/github-oauth-authentication-react-and-node)
