# GitHub OAuth Authentication React.js and Node.js(No Passport)

In this article, you'll learn how to implement GitHub OAuth Authentication with React.js and Node.js without using Passport. Also, you'll learn how to send JWT access and refresh token cookies after the user has been authenticated.

![GitHub OAuth Authentication React.js and Node.js(No Passport)](https://codevoweb.com/wp-content/uploads/2022/06/GitHub-OAuth-Authentication-React.js-and-Node.jsNo-Passport.png)

## Topics Covered

- Create an OAuth Application on GitHub
- Build the Consent Screen URL
- Build the GitHub OAuth Login Page with React and MUI
- Implement the OAuth Authentication on the Server
    - Get GitHub OAuth Access Token and User's Profile
    - Create a User Model
    - Create a Service to Update the User
    - Create the GitHub OAuth Controller
    - Create the Route


Read the entire article here: [https://codevoweb.com/github-oauth-authentication-react-and-node/](https://codevoweb.com/github-oauth-authentication-react-and-node/)


Articles in this series:

### 1. Node.js + TypeScript + MongoDB: JWT Authentication

[Node.js + TypeScript + MongoDB: JWT Authentication](https://codevoweb.com/node-typescript-mongodb-jwt-authentication)

### 2. Node.js + TypeScript + MongoDB: JWT Refresh Token

[Node.js + TypeScript + MongoDB: JWT Refresh Token](https://codevoweb.com/react-node-access-refresh-tokens-authentication)

### 3. Google OAuth Authentication with React.js and Node.js (No Passport)

[Google OAuth Authentication with React.js and Node.js (No Passport)](https://codevoweb.com/react-node-access-refresh-tokens-authentication)

### 4. GitHub OAuth Authentication React.js and Node.js(No Passport)

[GitHub OAuth Authentication React.js and Node.js(No Passport)](https://codevoweb.com/github-oauth-authentication-react-and-node)
