# Google OAuth Authentication with React.js and Node.js (No Passport)

In this article, you'll learn how to implement Google OAuth Authentication with React.js and Node.js without using Passport. 
You'll also learn how to send JWT access and refresh tokens after the user has been authenticated.

![Google OAuth Authentication with React.js and Node.js (No Passport)](https://codevoweb.com/wp-content/uploads/2022/06/Google-OAuth-Authentication-React.js-and-Node.jsNo-Passport.webp)

## Topics Covered

- Create Google client ID and client secret
    - Create a New Node.js Project
    - Create an OAuth Consent Screen
    - Create the OAuth Credentials
- Build the Consent Screen URL
- Build the Google OAuth Login Page with React and MUI
- Implement the OAuth Authentication on the Node.js Server
    - Get Google OAuth Access Token and User's Profile
    - Update the User Model
    - Add a Service to Update the User
    - Create the Google OAuth Controller
    - Create the Route
    - Register the Session Router


Read the entire article here: [https://codevoweb.com/google-oauth-authentication-react-and-node/](https://codevoweb.com/google-oauth-authentication-react-and-node/)


Articles in this series:

### 1. Node.js + TypeScript + MongoDB: JWT Authentication

[Node.js + TypeScript + MongoDB: JWT Authentication](https://codevoweb.com/node-typescript-mongodb-jwt-authentication)

### 2. Node.js + TypeScript + MongoDB: JWT Refresh Token

[Node.js + TypeScript + MongoDB: JWT Refresh Token](https://codevoweb.com/react-node-access-refresh-tokens-authentication)

### 3. Google OAuth Authentication with React.js and Node.js (No Passport)

[Google OAuth Authentication with React.js and Node.js (No Passport)](https://codevoweb.com/react-node-access-refresh-tokens-authentication)

### 4. GitHub OAuth Authentication React.js and Node.js(No Passport)

[GitHub OAuth Authentication React.js and Node.js(No Passport)](https://codevoweb.com/github-oauth-authentication-react-and-node)
