#  CRUD Operations on PostgreSQL using Django REST Framework

In this article, you'll learn how to implement CRUD operations on a PostgreSQL database using Django REST Framework. 

![CRUD Operations on PostgreSQL using Django REST Framework](https://codevoweb.com/wp-content/uploads/2024/11/CRUD-Operations-on-PostgreSQL-using-Django-REST-Framework.webp)

## Topics Covered

- Run and Test the Django API on Your Computer
- Set Up PostgreSQL and pgAdmin
- Connect the Django Project to the PostgreSQL Server
- Set Up the Django Project
- Create the Database and Serializer Models
  - Django Database Model
  - Django Serializer Model
- Generate and Apply the Database Migrations
- Create the CRUD API Views
  - Implement the Create and Get API Views
  - Implement the Read, Update, and Delete API Views
- Create Routes for the API Views
- Set Up CORS on the Django Server
- Test the CRUD Functionalities
  - Perform the Create Operation
  - Perform the Update Operation
  - Perform the Read Operation
  - Perform the Delete Operation
- Conclusion

  
Read the entire article here: [https://codevoweb.com/crud-operations-on-postgresql-using-django-rest-framework/](https://codevoweb.com/crud-operations-on-postgresql-using-django-rest-framework/)
