#  Build a CRUD Django REST API using Django REST Framework

In this tutorial, you'll learn how to build a CRUD Django REST API using the Django REST Framework.

![Build a CRUD Django REST API using Django REST Framework](https://codevoweb.com/wp-content/uploads/2024/11/Build-a-CRUD-Django-REST-API-using-Django-REST-Framework.webp)

## Topics Covered

- Run and Test the Django REST API Locally
- Set Up the Django Project
- Create the Django Database and Serializer Models
  - Database Model
  - Serializer Model
- Create the CRUD REST API Views in Django
  - Implement the GET and POST API Views
  - Implement the GET, PATCH, and DELETE API Views
  - Complete API Views
- Register the REST API Endpoints
  - Add the CRUD API URLs
  - Add the Base URL
- Set Up CORS on the Server
- Generate the Database Migrations
- Test the Django CRUD REST API Project
  - Create Feedback
  - Edit Feedback
  - Fetch All Feedback
  - Delete Feedback
- Conclusion

  
Read the entire article here: [https://codevoweb.com/build-a-crud-django-rest-api-using-django-rest-framework/](https://codevoweb.com/build-a-crud-django-rest-api-using-django-rest-framework/)
