#  CRUD RESTful API Server with Python, FastAPI, and MongoDB

This article will teach you how to create a CRUD RESTful API with Python, FastAPI, PyMongo, MongoDB, and Docker-compose to perform the basic Create/Read/Update/Delete operations against a database.

![CRUD RESTful API Server with Python, FastAPI, and MongoDB](https://codevoweb.com/wp-content/uploads/2022/07/CRUD-RESTful-API-Server-with-Python-FastAPI-and-MongoDB.webp)

## Topics Covered

- Python, FastAPI, MongoDB CRUD API Overview
- Setting up FastAPI with MongoDB
    - Installing FastAPI
- Running the FastAPI Server
- Loading Environment Variables with Pydantic
- Connecting to the MongoDB Database Server
- Creating the Schemas with Pydantic
- Serializers for the MongoDB Documents
- Creating the API Route Controllers
    - Get All Posts Controller
    - Create New Post Controller
    - Update Post Controller
    - Get Single Post Controller
    - Delete Post Controller
- Add the Routes to the FastAPI Middleware Stack

Read the entire article here: [https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-mongodb](https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-mongodb)

Articles in this series:

### 1. API with Python, FastAPI, and MongoDB: JWT Authentication

[API with Python, FastAPI, and MongoDB: JWT Authentication](https://codevoweb.com/api-with-python-fastapi-and-mongodb-jwt-authentication)

### 2. Build API with Python & FastAPI: SignUp User and Verify Email

[Build API with Python & FastAPI: SignUp User and Verify Email](https://codevoweb.com/api-with-python-fastapi-signup-user-and-verify-email)

### 3. CRUD RESTful API Server with Python, FastAPI, and MongoDB

[CRUD RESTful API Server with Python, FastAPI, and MongoDB](https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-mongodb)
