#  API with Python, FastAPI, and MongoDB: JWT Authentication

This article will teach you how to add JSON Web Token (JWT) authentication to your FastAPI app using PyMongo, Pydantic, FastAPI JWT Auth package, and Docker-compose.

![API with Python, FastAPI, and MongoDB: JWT Authentication](https://codevoweb.com/wp-content/uploads/2022/07/API-with-Python-FastAPI-and-MongoDB-JWT-Authentication.webp)

## Topics Covered

- How to Setup FastAPI with MongoDB
- Starting the FastAPI Server
- Set up Environment Variables with Pydantic
- Connect to the MongoDB Database
- Creating the Schemas with Pydantic
- Create Serializers for the MongoDB BSON Documents
- Password Management in FastAPI
- Creating Utility Functions to Sign and Verify JWTs
- Creating the Authentication Controllers in FastAPI
    - User Registration Handler
    - User Sign-in Handler
    - Refresh Access Token Handler
    - Sign out User Handler
- How to Protect Private Routes
- Creating a User Handler
- Adding the API Routes and CORS
- Testing the API with Postman

Read the entire article here: [https://codevoweb.com/api-with-python-fastapi-and-mongodb-jwt-authentication](https://codevoweb.com/api-with-python-fastapi-and-mongodb-jwt-authentication)

Articles in this series:

### 1. API with Python, FastAPI, and MongoDB: JWT Authentication

[API with Python, FastAPI, and MongoDB: JWT Authentication](https://codevoweb.com/api-with-python-fastapi-and-mongodb-jwt-authentication)

### 2. Build API with Python & FastAPI: SignUp User and Verify Email

[Build API with Python & FastAPI: SignUp User and Verify Email](https://codevoweb.com/api-with-python-fastapi-signup-user-and-verify-email)

### 3. CRUD RESTful API Server with Python, FastAPI, and MongoDB

[CRUD RESTful API Server with Python, FastAPI, and MongoDB](https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-mongodb)
