#  Golang & MongoDB: JWT Authentication and Authorization

In this article, you'll learn how to implement RS256 JWT (JSON Web Token) Authentication and Authorization with Golang, Gin Gonic, MongoDB-Go-driver, and Docker-compose.

![Golang & MongoDB: JWT Authentication and Authorization](https://codevoweb.com/wp-content/uploads/2022/05/Golang-and-MongoDB-JWT-Authentication-and-Authorization.webp)

## Topics Covered

- Golang & MongoDB JWT Authentication Overview
- JWT Authentication Example with Golang and MongoDB
- How to Generate Public and Private Keys
- Update Environment Variables with Viper
- Creating the User models with structs
- Creating an Auth and User Interfaces
    - Authentication Interface
    - User Interface
- Create utility functions to hash and verify password
- Create services that interact with the database
    - Auth interface implementation
    - User interface implementation
- Create a utility function to sign and verify JWT tokens
    - Create Json Web Token
    - Verify JSON Web Token
- Create the authentication controllers
    - Signup user controller
    - Login user controller
    - Refresh access token controller
    - Logout user controller
- Authentication Middleware Guard
- Create the user controllers
- Create API Routes with Gin
    - Auth Routes
    - User Routes
- Add the Routes to the Gin Middleware Pipeline

Read the entire article here: [https://codevoweb.com/golang-mongodb-jwt-authentication-authorization](https://codevoweb.com/golang-mongodb-jwt-authentication-authorization)

Articles in this series:

### 1. API with Golang + MongoDB + Redis + Gin Gonic: Project Setup

[API with Golang + MongoDB + Redis + Gin Gonic: Project Setup](https://codevoweb.com/api-golang-mongodb-gin-gonic-project-setup)

### 2. Golang & MongoDB: JWT Authentication and Authorization

[Golang & MongoDB: JWT Authentication and Authorization](https://codevoweb.com/golang-mongodb-jwt-authentication-authorization)

### 3. API with Golang + MongoDB: Send HTML Emails with Gomail

[API with Golang + MongoDB: Send HTML Emails with Gomail](https://codevoweb.com/api-golang-mongodb-send-html-emails-gomail)

### 4. API with Golang, Gin Gonic & MongoDB: Forget/Reset Password

[API with Golang, Gin Gonic & MongoDB: Forget/Reset Password](https://codevoweb.com/api-golang-gin-gonic-mongodb-forget-reset-password)

### 5. Build Golang gRPC Server and Client: SignUp User & Verify Email

[Build Golang gRPC Server and Client: SignUp User & Verify Email](https://codevoweb.com/golang-grpc-server-and-client-signup-user-verify-email)

### 6. Build Golang gRPC Server and Client: Access & Refresh Tokens

[Build Golang gRPC Server and Client: Access & Refresh Tokens](https://codevoweb.com/golang-grpc-server-and-client-access-refresh-tokens)

### 7. Build CRUD RESTful API Server with Golang, Gin, and MongoDB

[Build CRUD RESTful API Server with Golang, Gin, and MongoDB](https://codevoweb.com/crud-restful-api-server-with-golang-and-mongodb)

### 8. Build CRUD gRPC Server API & Client with Golang and MongoDB

[Build CRUD gRPC Server API & Client with Golang and MongoDB](https://codevoweb.com/crud-grpc-server-api-client-with-golang-and-mongodb)
