# Golang, SQLC, and PostgreSQL: JWT Access & Refresh Tokens

This article will teach you how to use the RS256 algorithm to implement JSON Web Token (JWT) Authentication and Authorization with Golang, Gin Gonic, SQLC, PostgreSQL, and Docker-compose. Also, you will learn how to use asymmetric encryption (private and public keys) to generate access and refresh JWTs in Golang.

![Golang, SQLC, and PostgreSQL: JWT Access & Refresh Tokens](https://codevoweb.com/wp-content/uploads/2022/06/Build-Golang-PostgreSQL-API-JWT-Access-and-Refresh-Tokens.webp)

## Topics Covered

- Golang & SQLC JWT Authentication Overview
- Setup Environment Variables with Viper
- Define the Database User models with Structs
- Define Helper Functions to hash and verify Passwords
- Define Utility functions to Sign and Verify JWT Tokens
- Create the Authentication Route Handlers
- Create an Authentication middleware
- Setup routing with Gin
- Configure the Main Server File

Read the entire article here: [https://codevoweb.com/golang-postgresql-api-access-and-refresh-tokens](https://codevoweb.com/golang-postgresql-api-access-and-refresh-tokens)

Articles in this series:

### 1. How to Setup SQLC CRUD API with Golang and Gin Gonic
[How to Setup SQLC CRUD API with Golang and Gin Gonic](https://codevoweb.com/api-golang-postgresql-sqlc-gin-gonic-project-setup)

### 2. Golang, SQLC, and PostgreSQL: JWT Access & Refresh Tokens
[Golang, SQLC, and PostgreSQL: JWT Access & Refresh Tokens](https://codevoweb.com/golang-postgresql-api-access-and-refresh-tokens)

### 3. Golang CRUD RESTful API with SQLC and PostgreSQL
[Golang CRUD RESTful API with SQLC and PostgreSQL](https://codevoweb.com/golang-crud-restful-api-with-sqlc-and-postgresql)
