# Golang CRUD RESTful API with SQLC and PostgreSQL

This article will teach you how to build a CRUD RESTful API in Golang that runs on a Gonic Gonic framework and uses a PostgreSQL database. Also, you will learn how to generate the CRUD Functions and Structs with SQLC. We will run the database migration with the Golang migrate library.

![Golang CRUD RESTful API with SQLC and PostgreSQL](https://codevoweb.com/wp-content/uploads/2022/09/Golang-CRUD-RESTful-API-with-SQLC-and-PostgreSQL.webp)

## Topics Covered

- Setup and Run PostgreSQL with Docker and Docker-compose
- Setup and Run Database Migration in Golang
- Generate the CRUD Functions and Structs with SQLC
- Load the Environment Variables with Viper
- Create Custom Structs to Validate the Request Body
- Create the Gin Gonic Route Controllers
- Create the Gin Gonic Routes
- Add the Routes to the Middleware Pipeline
- Test the SQLC + Golang CRUD API with Postman

Read the entire article here: [https://codevoweb.com/golang-crud-restful-api-with-sqlc-and-postgresql](https://codevoweb.com/golang-crud-restful-api-with-sqlc-and-postgresql)

Articles in this series:

### 1. How to Setup SQLC CRUD API with Golang and Gin Gonic
[How to Setup SQLC CRUD API with Golang and Gin Gonic](https://codevoweb.com/api-golang-postgresql-sqlc-gin-gonic-project-setup)

### 2. Golang, SQLC, and PostgreSQL: JWT Access & Refresh Tokens
[Golang, SQLC, and PostgreSQL: JWT Access & Refresh Tokens](https://codevoweb.com/golang-postgresql-api-access-and-refresh-tokens)

### 3. Golang CRUD RESTful API with SQLC and PostgreSQL
[Golang CRUD RESTful API with SQLC and PostgreSQL](https://codevoweb.com/golang-crud-restful-api-with-sqlc-and-postgresql)
