# How to Implement Google and GitHub OAuth in React.js

These articles will teach you how to set up GitHub and Google OAuth flow in React.js applications.

## How to Implement Google OAuth2 in React.js

In this article, you'll learn how to implement Google OAuth2 in a React.js application, including creating a project in the Google API Console, configuring the application's client ID and redirect URI, and implementing the necessary code in the React application.

![How to Implement Google OAuth2 in React.js](https://codevoweb.com/wp-content/uploads/2023/01/How-to-Implement-Google-OAuth2-in-React.js.webp)

### Topics Covered

- Run the React Google OAuth2 Project
- Run the React app with a Node.js API
- Run the React app with a Golang API
- Setup the React Project
- Get the Google OAuth2 Client ID and Secret
- Build the OAuth2 Consent Screen Link
- Create a Zustand Store
- Create Reusable React Components
    - Create a Spinner Component
    - Create a Header Component
    - Create a Layout Component
- Implement the Authentication
    - Account Registration Page
    - Login Page
- Create the Remaining Pages
    - Home Page
    - Profile Page
- Create Routes for the Pages
- Test the Google OAuth2 Flow
     - Create an Account
     - Login with OAuth2
     - Access the Protected Page

Read the entire article here: [https://codevoweb.com/how-to-implement-google-oauth2-in-reactjs/](https://codevoweb.com/how-to-implement-google-oauth2-in-reactjs/)

## How to Implement GitHub OAuth in React.js

In this article, you'll learn how to implement GitHub OAuth in a React.js application, including creating an OAuth app in the GitHub developer settings page, configuring the application's client ID, client secrets, and redirect URI, and implementing the necessary code in the React application.

![How to Implement GitHub OAuth in React.js](https://codevoweb.com/wp-content/uploads/2023/01/How-to-Implement-GitHub-OAuth-in-React.js.webp)

### Topics Covered

- Run the React GitHub OAuth Project
- Run the React App with Node.js API
- Run the React App with Golang API
- Setup the React Project
- Get the GitHub OAuth Credentials
- Generate the GitHub Consent Screen Link
- Setup a React Store with Zustand
- Create Reusable Components
    - Spinner Component
    - Header Component
    - Layout Component
- Implement the GitHub OAuth
    - Account Registration Component
    - Login Component
- Create the Other Pages
    - Home Page Component
    - Profile Page Component
- Create Routes for the Pages

Read the entire article here: [https://codevoweb.com/how-to-implement-github-oauth-in-reactjs/](https://codevoweb.com/how-to-implement-github-oauth-in-reactjs/)



