# How to Implement GitHub and Google OAuth in Node.js and Express

In these articles, you'll learn how to implement Google and GitHub OAuth in Node.js applications.

## How to Implement Google OAuth2 in Node.js

In this article, I'll walk you through the process of setting up Google OAuth2 in a Node.js application, including creating the OAuth project on the Google API console, configuring the OAuth Client ID and secret, and implementing the necessary code in the Node.js project. 

![How to Implement Google OAuth2 in Node.js](https://codevoweb.com/wp-content/uploads/2023/01/How-to-Implement-Google-OAuth2-in-Node.js.webp)

### Topics Covered

- Run the Node.js Google OAuth2 Project
- Run the Node.js API with a React.js App
- Setup the Node.js Project
- Get the Google OAuth2 Credentials
- Setup the Database with Prisma
- Create the Validation Schemas
- Get the Google OAuth Access Token and User's Info
    - Get the OAuth Access Token
    - Get the Google Account User
- Implement the Google OAuth2 in Node.js
    - Register User Route Handler
    - Login User Route Handler
    - Logout User Route Handler
    - Authenticate with Google OAuth2 Route Handler
- Create a User Route Handler
- Create the Authentication Guards
    - Authentication Middleware
    - Require User Middleware
- Create the API Routes
- Setup CORS and Register the API Routers

Read the entire article here: [https://codevoweb.com/how-to-implement-google-oauth2-in-nodejs/](https://codevoweb.com/how-to-implement-google-oauth2-in-nodejs/)


## How to Implement GitHub OAuth in Node.js

In this tutorial, I'll walk you through the process of integrating GitHub OAuth into a Node.js application, including setting up the OAuth App on GitHub, retrieving the OAuth client ID and secret, and implementing the necessary code to handle the OAuth flow.

![How to Implement GitHub OAuth in Node.js](https://codevoweb.com/wp-content/uploads/2023/01/How-to-Implement-GitHub-OAuth-in-Node.js.webp)

### Topics Covered

- Run the Node.js GitHub OAuth Project
- Run the Node.js API with a React App
- Setup the Node.js Project
- Get the GitHub OAuth Credentials
- Create the Database Model
- Create the Validation Schemas
- Obtain the GitHub OAuth Access Token and User's Info
    - Retrieve the OAuth Access Token
    - Retrieve the GitHub Account Information
- Implement GitHub OAuth in Node.js
    - Account Registration Route Function
    - Account Login Route Function
    - Logout Route Function
    - Authenticate with GitHub OAuth Route Function
- GetMe Route Function
- Create the Authentication Middleware
    - Authentication Guard
    - Require User Middleware
- Create the API Routes
- Register the API Routes and Setup CORS

Read the entire article here: [https://codevoweb.com/how-to-implement-github-oauth-in-nodejs/](https://codevoweb.com/how-to-implement-github-oauth-in-nodejs/)
