# Next.js Full-Stack App with React Query, and GraphQL-CodeGen

This article will teach you how to build a full-stack CRUD App with Next.js, React Query, GraphQL Code Generator, React-Hook-Form, Zod, and graphql-request to perform Create/Update/Get/Delete operations.

![Next.js Full-Stack App with React Query, and GraphQL-CodeGen](https://codevoweb.com/wp-content/uploads/2022/07/Next.js-Full-Stack-App-with-React-Query-and-GraphQL-CodeGen.webp)

## Topics Covered

- Next.js Full-Stack CRUD App Overview
- Benefits of React Query
- Setup GraphQL Code Generator
- Creating the GraphQL Mutations and Queries
    - Create Post Mutation
    - Update Post Mutation
    - Delete Post Mutation
    - Get a Single Post Query
    - Get All Post Query
- Generating the React Query Hooks with CodeGen
- Create Reusable Components with tailwindCss
    - Creating the Modal Component
    - Creating the Message Component
    - Creating a Custom Input Field with React-Hook-Form
- GraphQL Request and React Query Clients
- React Query & GraphQL Request Create Mutation
- React Query & GraphQL Request Update Mutation
- React Query & GraphQL Request Delete Mutation
- React Query & GraphQL Request Get Query

Read the entire article here: [https://codevoweb.com/nextjs-full-stack-app-with-react-query-and-graphql-codegen](https://codevoweb.com/nextjs-full-stack-app-with-react-query-and-graphql-codegen)

Articles in this series::

1. [GraphQL API with Next.js & MongoDB: Access & Refresh Tokens](https://codevoweb.com/graphql-api-next-mongodb-access-and-refresh-tokens)
2. [Next.js, GraphQL-CodeGen, & React Query: JWT Authentication](https://codevoweb.com/nextjs-graphql-codegen-react-query-jwt-authentication)
3. [GraphQL CRUD API with Next.js, MongoDB, and TypeGraphQL](https://codevoweb.com/graphql-crud-api-nextjs-mongodb-typegraphql)
4. [Next.js Full-Stack App with React Query, and GraphQL-CodeGen](https://codevoweb.com/nextjs-full-stack-app-with-react-query-and-graphql-codegen)

