# CRUD API with Node.js and PostgreSQL: Send HTML Emails

In this article, you'll learn how to send HTML Emails with Node.js, Nodemailer, Prisma, PostgreSQL, Express, and Docker-compose. We'll create a generic class that can be used to send single or multiple emails at once by chaining the methods together.

![CRUD API with Node.js and PostgreSQL: Send HTML Emails](https://codevoweb.com/wp-content/uploads/2022/05/CRUD-API-with-Node.js-and-PostgreSQL-Send-HTML-Emails.webp)

## Topics Covered

- Send Emails with Node.js, Nodemailer, Prisma Overview
- Setting up ExpressJs Templating Engine with Pug
- Create a Utility Class to the Send Emails
    - Get the Nodemailer Credentials
    - Define the Email Class Attributes
    - Create a Nodemailer Transporter
    - Create a Method to Generate the Email Templates
    - Create a Method to Send the Emails
- Creating the Email Templates with Pug
- Run Prisma Migration to Update PostgreSQL Schema
- Update the User Registration Controller to Send the Emails
- Create a Route Handler to Verify the Email
- Update the Login Controller

Read the entire article here: [https://codevoweb.com/crud-api-node-js-and-postgresql-send-html-emails](https://codevoweb.com/crud-api-node-js-and-postgresql-send-html-emails)

Articles in this series:

### 1. Setup Node.js API with Prisma, TypeScript, and PostgreSQL

[Setup Node.js API with Prisma, TypeScript, and PostgreSQL](https://codevoweb.com/api-node-typescript-prisma-postgresql-project-setup)

### 2. Node.js + Prisma + PostgreSQL: Access & Refresh Tokens

[API Node.js, TypeScript, Prisma, PostgreSQL: Project Setup](https://codevoweb.com/node-prisma-postgresql-access-refresh-tokens)

### 3. CRUD API with Node.js and PostgreSQL: Send HTML Emails

[CRUD API with Node.js and PostgreSQL: Send HTML Emails](https://codevoweb.com/crud-api-node-js-and-postgresql-send-html-emails)

### 4. API with Node.js, Prisma & PostgreSQL: Forget/Reset Password

[API with Node.js, Prisma & PostgreSQL: Forget/Reset Password](https://codevoweb.com/crud-api-node-prisma-postgresql-reset-password)
