# Setup Node.js API with Prisma, TypeScript, and PostgreSQL

In this comprehensive article, you'll learn how to set up a Node.js API Project with ExpressJs, Prisma, PostgreSQL, Redis, and Docker-compose. The API will run on an Express server and use Postgres for data storage.

![Setup Node.js API with Prisma, TypeScript, and PostgreSQL](https://codevoweb.com/wp-content/uploads/2022/05/API-Node.js-TypeScript-Prisma-PostgreSQL-Project-Setup.webp)

## Topics Covered

- Initialize a Prisma Project with Express.js
- Generate a database schema with the Prisma CLI
- Defining the User Model with Prisma
- Database Migration with Prisma
- Connect the ExpressJs App to the Redis Server
- Connecting to PostgreSQL and Redis with MySQL VS Code Extension

Read the entire article here: [https://codevoweb.com/api-node-typescript-prisma-postgresql-project-setup](https://codevoweb.com/api-node-typescript-prisma-postgresql-project-setup)

Articles in this series:

### 1. Setup Node.js API with Prisma, TypeScript, and PostgreSQL

[Setup Node.js API with Prisma, TypeScript, and PostgreSQL](https://codevoweb.com/api-node-typescript-prisma-postgresql-project-setup)

### 2. Node.js + Prisma + PostgreSQL: Access & Refresh Tokens

[API Node.js, TypeScript, Prisma, PostgreSQL: Project Setup](https://codevoweb.com/node-prisma-postgresql-access-refresh-tokens)

### 3. CRUD API with Node.js and PostgreSQL: Send HTML Emails

[CRUD API with Node.js and PostgreSQL: Send HTML Emails](https://codevoweb.com/crud-api-node-js-and-postgresql-send-html-emails)

### 4. API with Node.js, Prisma & PostgreSQL: Forget/Reset Password

[API with Node.js, Prisma & PostgreSQL: Forget/Reset Password](https://codevoweb.com/crud-api-node-prisma-postgresql-reset-password)
