#  CRUD RESTful API Server with Python, SQLAlchemy, FastAPI, and PostgreSQL

This article will teach you how to create a CRUD RESTful API with Python, FastAPI, SQLAlchemy ORM, Pydantic, Alembic, PostgreSQL, and Docker-compose to perform the basic Create/Read/Update/Delete operations against a database.

![CRUD RESTful API Server with Python, SQLAlchemy, FastAPI, and PostgreSQL](https://codevoweb.com/wp-content/uploads/2022/07/CRUD-RESTful-API-Server-with-Python-FastAPI-and-PostgreSQL.webp)

## Topics Covered

- Python, FastAPI, PostgreSQL, SQLAlchemy CRUD API Overview
- Setting up FastAPI and PostgreSQL
    - Building the FastAPI Server
    - Starting the FastAPI Server
- Setting up Environment Variables in FastAPI
- Connecting to the PostgreSQL Server
- Installing the UUID OSSP PostgreSQL Plugin
- How to Create Database Models with SQLAlchemy
- Creating Validation Schemas with Pydantic
- Creating the FastAPI Route Handlers
    - Fetch All Posts Handler
    - Create New Post Handler
    - Update Post Handler
    - Get a Single Post Handler
    - Remove Post Handler
- Add the Routes to the FastAPI Middleware Stack

Read the entire article here: [https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-postgresql](https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-postgresql)

### 1. RESTful API with Python,SQLAlchemy, & FastAPI: Access and Refresh Tokens

[RESTful API with Python, SQLAlchemy, & FastAPI: Access and Refresh Tokens](https://codevoweb.com/restful-api-with-python-fastapi-access-and-refresh-tokens)

### 2. RESTful API with Python, SQLAlchemy, & FastAPI: Send HTML Emails

[RESTful API with Python, SQLAlchemy & FastAPI: Send HTML Emails](https://codevoweb.com/restful-api-with-python-fastapi-send-html-emails)

### 3. CRUD RESTful API Server with Python, FastAPI, SQLAlchemy, and PostgreSQL

[CRUD RESTful API Server with Python, FastAPI, SQLAlchemy, and PostgreSQL](https://codevoweb.com/crud-restful-api-server-with-python-fastapi-and-postgresql)
