# Rust - Build a CRUD API with SQLX and PostgreSQL

In this article, you'll learn how to build a CRUD API in Rust using SQLX, Actix-web, and PostgreSQL. Learning how to build a CRUD API as a developer will equip you with valuable skills for building robust, maintainable, and scalable applications.

![Rust - Build a CRUD API with SQLX and PostgreSQL](https://codevoweb.com/wp-content/uploads/2023/01/Rust-Build-a-CRUD-API-with-SQLX-and-PostgreSQL.webp)

## Topics Covered

- Run the Rust SQLX Project Locally
- Run the Rust SQLX API with a React.js App
- Setup the Rust Project
- Setup PostgreSQL and pgAdmin with Docker
- Create and Migrate the Database Queries
- Create the SQLX Database Model
- Create the Validation Schemas
- Create CRUD Route Functions
    - Fetch All Records
    - Add New Record
    - Retrieve a Single Record
    - Edit an Existing Record
    - Delete a Record
    - Merge the Route Functions
- Register the Routes and Add CORS
- Test the Rust CRUD API
    - Perform the CREATE Operation
    - Perform the UPDATE Operation
    - Perform the READ Operation
    - Perform the DELETE Operation


Read the entire article here: [https://codevoweb.com/rust-build-a-crud-api-with-sqlx-and-postgresql/](https://codevoweb.com/rust-build-a-crud-api-with-sqlx-and-postgresql/)

