package com.javacodegeeks.examples;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class HashMapExample {
	
	
	public static void main(String[] args) {
		Map<Integer,Person> hashTable = new HashMap<>();
		Random rnd = new Random();
		
		String baseName = "Base_Name";

		//loading values into the hash table
		for (int i=0;i<100;i++) {
			String tmpName = baseName+i;
			int rndAge = rnd.nextInt(70);
			
			Person p = new Person(tmpName, rndAge);
			
			hashTable.put(tmpName.hashCode(), p);
		}
		
		//now let's find the person with name Base_Name75
		
		String name = "Base_Name75";
		Person person = hashTable.get(name.hashCode());
		System.out.println(person.getName());
	}
	
	
	static class Person {
		private String name;
		private int age;
		
		public Person(String name, int age) {
			this.name = name;
			this.age = age;
		}
		
		public String getName() {
			return this.name;
		}
		
		public int getAge() {
			return this.age;
		}
	}
}
