package com.javacodegeeks.examples;

public class Person {
		private String name;
		private int age;
		
		public Person(String name, int age) {
			this.name = name;
			this.age = age;
		}
		
		public String getName() {
			return this.name;
		}
		
		public int getAge() {
			return this.age;
		}
        
        @Override
        public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Person)) {
            return false;
        }
        Person person = (Person)object;
        return name.equals(person.name)
                && (age == person.age);
       }

       @Override
       public int hashCode() {
        int result =  age+1;
        result = 31 * result + name == null ? 0 : name.hashCode();
        return result;
       }
    
    
      public static void main(String[] args)
      {
          
          Person person = new Person("Jack",34);

          System.out.println(person.hashCode());
          
          Person person2 = new Person("George",44);
 
          System.out.println(person2.hashCode());
      
          System.out.println(person.equals(person2));
      }
	}