package com.javacodegeeks.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;

import com.northconcepts.datapipeline.core.DataReader;
import com.northconcepts.datapipeline.core.DataWriter;
import com.northconcepts.datapipeline.core.StreamWriter;
import com.northconcepts.datapipeline.csv.CSVWriter;
import com.northconcepts.datapipeline.filter.FilterExpression;
import com.northconcepts.datapipeline.jdbc.JdbcWriter;
import com.northconcepts.datapipeline.job.Job;
import com.northconcepts.datapipeline.json.JsonReader;
import com.northconcepts.datapipeline.transform.BasicFieldTransformer;
import com.northconcepts.datapipeline.transform.SetField;
import com.northconcepts.datapipeline.transform.TransformingReader;

public class ReadJsonFromUrl {

	public void readAJsonStream() throws Exception {

		String url = "http://www.google.com/finance/info?client=ig&q=msft,orcl,adbe";

		BufferedReader input = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "UTF-8"));

		// remove preceding slashes from stream
		input.readLine();
		input.read();
		input.read();

		DataReader reader = new JsonReader(input)
				.addField("symbol", "//array/object/t")
				.addField("exchange", "//array/object/e")
				.addField("price", "//array/object/l")
				.addField("change", "//array/object/c")
				.addRecordBreak("//array/object");

		reader = new TransformingReader(reader)
				.add(new BasicFieldTransformer("price").stringToDouble())
				.add(new BasicFieldTransformer("change").stringToDouble());

		DataWriter writer = new StreamWriter(System.out);

		Job.run(reader, writer);
	}
	
	public void readAJsonStreamAndWriteToCsv() throws Exception {

		String url = "http://www.google.com/finance/info?client=ig&q=aapl,mcd";

		BufferedReader input = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "UTF-8"));

		// remove preceding slashes from stream
		input.readLine();
		input.read();
		input.read();

		DataReader reader = new JsonReader(input)
				.addField("symbol", "//array/object/t")
				.addField("exchange", "//array/object/e")
				.addField("price", "//array/object/l")
				.addField("change", "//array/object/c")
				.addRecordBreak("//array/object");

		reader = new TransformingReader(reader)
				.add(new BasicFieldTransformer("price").stringToDouble())
				.add(new BasicFieldTransformer("change").stringToDouble());

		DataWriter writer = new CSVWriter(new File("Apple-McDonalds.txt"));

		Job.run(reader, writer);
	}
	
	public void readAJsonStreamAndTransformTheData() throws Exception {
		
		String url = "http://www.google.com/finance/info?client=ig&q=aapl,mcd";

		BufferedReader input = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "UTF-8"));

		// remove preceding slashes from stream
		input.readLine();
		input.read();
		input.read();

		DataReader reader = new JsonReader(input).addField("symbol", "//array/object/t")
				.addField("exchange", "//array/object/e")
				.addField("price", "//array/object/l")
				.addField("change", "//array/object/c")
				.addRecordBreak("//array/object");

		reader = new TransformingReader(reader)
				.add(new BasicFieldTransformer("price").stringToDouble())
				.add(new BasicFieldTransformer("change").stringToDouble());
		
		reader = new TransformingReader(reader)
                .setCondition(new FilterExpression("symbol == 'AAPL' && price < 165.00"))
                .add(new SetField("recommendation", "BUY"));

		DataWriter writer = new StreamWriter(System.out);

		Job.run(reader, writer);
	}
	
	public void readAJsonStreamAndWriteToDatabase() throws Exception {
		
		// connect to the database
        String dbUrl = "jdbc:mysql://localhost/stocks?user=root&password=root";
        Connection connection = DriverManager.getConnection(dbUrl);
		
		String url = "http://www.google.com/finance/info?client=ig&q=mcd,aapl";

		BufferedReader input = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "UTF-8"));

		// remove preceding slashes from stream
		input.readLine();
		input.read();
		input.read();

		DataReader reader = new JsonReader(input).addField("symbol", "//array/object/t")
				.addField("bourse", "//array/object/e")
				.addField("price", "//array/object/l")
				.addField("price_change", "//array/object/c")
				.addRecordBreak("//array/object");

		reader = new TransformingReader(reader)
				.add(new BasicFieldTransformer("price").stringToDouble())
				.add(new BasicFieldTransformer("price_change").stringToDouble());
		
		reader = new TransformingReader(reader)
                .setCondition(new FilterExpression("symbol != 'AAPL'"))
                .add(new SetField("recommendation", "WAIT"));
		
		reader = new TransformingReader(reader)
                .setCondition(new FilterExpression("symbol == 'AAPL' && price < 165.00"))
                .add(new SetField("recommendation", "BUY"));

		DataWriter writer = new  JdbcWriter(connection, "usa")
	            .setAutoCloseConnection(true);

		Job.run(reader, writer);
	}
}
