package com.jcg.java;

import java.util.ArrayList;
import java.util.List;

/*
 * To enable 'parallelism', all you have to do is to create a parallel stream, 
 * instead of a sequential stream. And to suprise you, this is really very
 * easy.
 * 
 * Anytime you want to particular job using multiple threads in parallel cores,
 * all you have to call the 'parallelStream()' method instead of the 'stream()'
 * method.
 */
public class ParallelStreamDemo {

	public static void main(String[] args) {

		long t1, t2;
		List<Employee> eList = new ArrayList<Employee>();
		for(int i=0; i<100; i++) {
			eList.add(new Employee("A", 20000));
			eList.add(new Employee("B", 3000));
			eList.add(new Employee("C", 15002));
			eList.add(new Employee("D", 7856)); 
			eList.add(new Employee("E", 200)); 
			eList.add(new Employee("F", 50000));
		}

		/***** Here We Are Creating A 'Sequential Stream' & Displaying The Result *****/
		t1 = System.currentTimeMillis();   
		System.out.println("Sequential Stream Count?= " + eList.stream().filter(e -> e.getSalary() > 15000).count());

		t2 = System.currentTimeMillis();
		System.out.println("Sequential Stream Time Taken?= " + (t2-t1) + "\n");

		/***** Here We Are Creating A 'Parallel Stream' & Displaying The Result *****/
		t1 = System.currentTimeMillis();		
		System.out.println("Parallel Stream Count?= " + eList.parallelStream().filter(e -> e.getSalary() > 15000).count());

		t2 = System.currentTimeMillis();
		System.out.println("Parallel Stream Time Taken?= " + (t2-t1));
	}
}