
import java.util.concurrent.BlockingQueue;

public class ConsumerClass implements Runnable {

    private BlockingQueue<MessageClass> queue;

    public ConsumerClass(BlockingQueue<MessageClass> q) {
        this.queue = q;
    }

    @Override
    public void run() {
        try {
            MessageClass msg;
            while ((msg = queue.take()).getMessageString() != "exit") {
                Thread.sleep(10);
                System.out.println("Consumed " + msg.getMessageString());
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
