# python random tutorial

import random


# generate random integers
# randint() method generates a random integer between the given min and max integers
def random_integer(minimum, maximum):
    rand_number = random.randint(minimum, maximum)
    print("Random integer number is = {}".format(rand_number))


# generate random floats
# random() method generates a random floating number between 0.0 to 1.0
def random_float():
    rand_number = random.random()
    print("Random float number is = {}".format(rand_number))


# generate random number within range
# randrange() method generates a randomly selected element from the range created by the
# beginning, ending, and step arguments
# default value is beginning is 0 and step is 1
def random_range(beg, end, step):
    rand_number = random.randrange(beg, end, step)
    print("Random number from range is = {}".format(rand_number))


# select random elements
# choice() method generates a randomly selected element from a non-empty sequence
# if sequence is empty -> IndexError is thrown by the python compiler
def random_choice(sequence):
    rand_number = random.choice(sequence)
    print("Random number from sequence is = {}".format(rand_number))


# shuffle elements
# shuffle() method randomly reorders the elements in a list
def random_shuffle(number_list):
    random.shuffle(number_list)
    print("Randomly reordered = {}".format(number_list))


# driver code
if __name__ == "__main__":
    print("==== Python Random Tutorial ====")
    print("\n")
    random_integer(10, 50)
    print("\n")
    random_float()
    print("\n")
    random_range(5, 10, 2)
    print("\n")
    random_choice([5, 10, 15, 20, 25])
    print("\n")
    random_choice('python')
    print("\n")
    random_shuffle([15, 20, 25, 30, 35, 50, 100])
