﻿Imports System
Imports System.Data
Imports System.Data.SqlClient

Partial Class Database_ADONET_SqlCommandInsert
    Inherits System.Web.UI.Page

    Protected Sub btnInsert_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnInsert.Click
        Dim thisConnection As New SqlConnection(ConfigurationManager.ConnectionStrings("Northwind_ConnectionString").ConnectionString)

        'Create Command object
        Dim nonqueryCommand As SqlCommand = thisConnection.CreateCommand()

        Try
            ' Open Connection
            thisConnection.Open()

            ' Create INSERT statement with named parameters
            nonqueryCommand.CommandText = _
               "INSERT  INTO Employees (FirstName, LastName) VALUES (@FirstName, @LastName)"

            ' Add Parameters to Command Parameters collection
            nonqueryCommand.Parameters.Add("@FirstName", SqlDbType.VarChar, 10)
            nonqueryCommand.Parameters.Add("@LastName", SqlDbType.VarChar, 20)

            
            nonqueryCommand.Parameters("@FirstName").Value = txtFirstName.Text
            nonqueryCommand.Parameters("@LastName").Value = txtLastName.Text

            nonqueryCommand.ExecuteNonQuery()

        Catch ex As SqlException
            ' Display error
            lblErrMsg.Text = ex.ToString()
            lblErrMsg.Visible = True

        Finally
            ' Close Connection
            thisConnection.Close()
            
        End Try
        GridView1.DataBind()
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        lblErrMsg.Visible = False

    End Sub
End Class
