﻿Imports System
Imports System.Data
Imports System.Data.SqlClient

Partial Class Database_ADONET_SqlCommandUpdate
    Inherits System.Web.UI.Page

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Dim thisConnection As New SqlConnection(ConfigurationManager.ConnectionStrings("Northwind_ConnectionString").ConnectionString)

        'Create Command object
        Dim nonqueryCommand As SqlCommand = thisConnection.CreateCommand()

        Try
            ' Open Connection
            thisConnection.Open()

            ' 1. Create Command
            ' Sql Update Statement
            Dim updateSql As String = _
               "UPDATE Employees " & _
               "SET LastName = @LastName " & _
               "WHERE FirstName = @FirstName"
            Dim UpdateCmd As New SqlCommand(updateSql, thisConnection)

            ' 2. Map Parameters

            UpdateCmd.Parameters.Add("@FirstName", _
               SqlDbType.NVarChar, 10, "FirstName")

            UpdateCmd.Parameters.Add("@LastName", _
               SqlDbType.NVarChar, 20, "LastName")


            UpdateCmd.Parameters("@FirstName").Value = txtFirstName.Text
            UpdateCmd.Parameters("@LastName").Value = txtLastName.Text

            UpdateCmd.ExecuteNonQuery()

        Catch ex As SqlException
            ' Display error
            lblErrMsg.Text = ex.ToString()
            lblErrMsg.Visible = True

        Finally
            ' Close Connection
            thisConnection.Close()

        End Try
        GridView1.DataBind()
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        lblErrMsg.Visible = False

    End Sub
End Class
