
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: takes a decimal or double number and returns a value
' that represents the next equal or higher whole number.
' Although the result is a whole number, it is returned as a
' the same data type that was passed in.  Math.Floor is different
' in that it rounds down to the next whole number that is equal
' or less than the number that is given.
'
' Syntax: 	Ceiling(decimalnumber)
'
' Parameter1: decimalnumber - decimal number
'
' Result: decimal - closest whole number equal or higher
'
' Syntax2: 	Ceiling(doublenumber)
'
' Parameter1: doublenumber - double  precision floating point number
'
' Result: double precision floating point number - closest whole number equal or higher
'
' Quick Example: Ceiling(1.9) ' Returns 2
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Ceiling
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Ceiling(1.32) - rounds up to closest whole number"
        Dim decNumber1 As Decimal = 1.32D

        TextBox1.Text = Ceiling(decNumber1) ' Returns 2


        Label2.Text = "Example #2: 	Ceiling(1.9) - rounds up to closest whole number"
        Dim douNumber2 As Double = 1.9

        TextBox2.Text = Ceiling(douNumber2) ' Returns 2
		

        Label3.Text = "Example #3: Ceiling(-1.32) - rounds up to closest whole number"

        Dim decNumber3 As Decimal = -1.32D


        TextBox3.Text = Ceiling(decNumber3) ' Returns -1


    End Sub
End Class
