
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: takes an dividend, divisor, and remainder as Int32 or Int64
' and returns quotient as same data type.  Remainder is passed by
' reference and it gets updated with the remainder when the function
' executes.
'
' *******************************************************************************
' Syntax: 	 DivRem(dividend32, divisor32, byRef remainder32)
'
' Parameter1: dividend32 - int32
'
' Parameter2: divisor32 - int32
'
' Parameter3: remainder32 - byRef int32
'
' Result: int32 - quotient
'
' ******************************************************************************
' Syntax2: 	DivRem(dividend64, divisor64, byRef remainder64)
'
'
' Parameter1: dividend64 - int64
'
' Parameter2: divisor64 - int64
'
' Parameter3: remainder64 - byRef int64
'
' Result: int64 - quotient
'
' Quick Example: Dim int32Dividend As Int32 = 7
' Dim int32Divisor As Int32 = 5
' Dim int32Quotient As Int32 = 0
' Dim int32Remainder As Int32 = 0



Partial Class _DivRem
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	DivRem(dividend as int32, divisor as int32, byRef remainder as int32)"
        Dim int32Dividend As Int32 = 7
        Dim int32Divisor As Int32 = 5
        Dim int32Quotient As Int32 = 0
        Dim int32Remainder As Int32 = 0

        int32Quotient = DivRem(int32Dividend, int32Divisor, int32Remainder)


        TextBox1.Text = "Quotient=" & int32Quotient ' Returns 1


        Label2.Text = "Example #2: 	DivRem(dividend as int64, divisor as int64, byRef remainder as int64)"
        Dim int64Dividend As Int64 = 7
        Dim int64Divisor As Int64 = 5
        Dim int64Quotient As Int64 = 0
        Dim int64Remainder As Int64 = 0

        int64Quotient = DivRem(int64Dividend, int64Divisor, int64Remainder)


        TextBox2.Text = "Quotient=" & int64Quotient ' Returns 1
		



    End Sub
End Class
