
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: takes a decimal or double number and returns a value
' that represents the next equal or lower whole number.
' Although the result is a whole number, it is returned as a
' the same data type that was passed in.  Math.Ceiling is different
' in that it rounds up to the next whole number that is equal
' or greater than the number that is given.
'
' Syntax: 	Floor(decimalnumber)
'
' Parameter1: decimalnumber - decimal number
'
' Result: decimal - closest whole number equal or lower
'
' Syntax2: 	Floor(doublenumber)
'
' Parameter1: doublenumber - double  precision floating point number
'
' Result: double precision floating point number - closest whole number equal or lower
'
' Quick Example: Floor(1.32) ' Returns 1
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Floor
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Floor(1.32) - rounds down to closest whole number"
        Dim decNumber1 As Decimal = 1.32D

        TextBox1.Text = Floor(decNumber1) ' Returns 1


        Label2.Text = "Example #2: 	Floor(1.9) - rounds down to closest whole number"
        Dim douNumber2 As Double = 1.9

        TextBox2.Text = Floor(douNumber2) ' Returns 1
		

        Label3.Text = "Example #3: Floor(-1.32) - rounds down to closest whole number"

        Dim decNumber3 As Decimal = -1.32D


        TextBox3.Text = Floor(decNumber3) ' Returns -2


    End Sub
End Class
