
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: Returns the Min value of the two parameters that were passed in.
'
'
' Syntax: 	Min(byte,byte)
' Min(decimal, decimal)
' Min(double, double)
' Min(int16, int16)
' Min(int32, int32)
' Min(int64, int64)
' Min(sbyte, sbyte)
' Min(single, single)
' Min(UInt16, UInt16)
' Min(UInt32, UInt32)
' Min(UInt64, UInt64)
'
' Parameter1: expression - 1. byte - returns byte that is Minimum of two inputs
' 2. decimal - returns decimal number that is Minimum of two inputs
' 3. double - returns double-percision floating point number that is Minimum of two inputs
' 4. int16 - returns 16-bit integer that is Minimum of two inputs
' 5. int32 - returns 32-bit integer that is Minimum of two inputs
' 6. int64 - returns 64-bit integer that is Minimum of two inputs
' 7. sbyte - returns 8-bit signed integer that is Minimum of two inputs
' 8. single - returns single-percision floating point number that is Minimum of two inputs
' 9. UInt16 - returns unsigned 16-bit integer that is Minimum of two inputs
' 10. UInt32 - returns unsigned 32-bit integer that is Minimum of two inputs
' 11. UInt64 - returns unsigned 64-bit integer that is Minimum of two inputs
'
' Result: Depends on input - 1. byte - when input is byte
' 2. decimal - when input is decimal
' 3. double - returns double-percision floating point number
' 4. int16 - returns 16-bit integer
' 5. int32 - returns 32-bit integer
' 6. int64 - returns 64-bit integer
' 7. sbyte - returns 8-bit signed integer
' 8. single - returns single-percision floating point number
' 9. UInt16 - returns unsigned 16-bit integer
' 10. UInt32 - returns unsigned 32-bit integer
' 11. UInt64 - returns unsigned 64-bit integer
'
' Quick Example: Min(1.33, 1.34) ' Returns 1.33
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Min
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Min(decimal,decimal)"
        Dim decNumber1 As Decimal = 1.33
        Dim decNumber2 As Decimal = 1.34


        TextBox1.Text = Min(decNumber1, decNumber2) ' Returns 1.33 as decimal


        Label2.Text = "Example #2: 	Min(douNumber1,douNumber2)"
        Dim douNumber1 As Double = -3.4
        Dim douNumber2 As Double = -2.4

        TextBox2.Text = Min(douNumber1, douNumber2) ' Returns -3.4 as double
		

        Label3.Text = "Example #3: 	Min(byte,byte)"

        Dim byteNumber1 As Integer = 5
        Dim byteNumber2 As Integer = 6



        TextBox3.Text = Min(byteNumber1, byteNumber2) ' Returns 5 as byte


    End Sub
End Class
