
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: takes a decimal or double as input parameter1
' and returns the number rounded to the specified number
' of fractional decimals. If parameter 2 is not used,
' result is rounded to whole number. Parameter3 specifies
' rounding mode
'
' Syntax: 	1. Round(decimal)
' 2. Round(decimal, int32)
' 3. Round(decimal, mode)
' 4. Round(decimal, int32, mode)
' 5. Round(double)
' 6. Round(double, int32)
' 7. Round(double, mode)
' 8. Round(double, int32, mode)
'
' Parameter1: decimal - Any valid System.Decimal data type number
' double - any valid System.Double data type.
' Parameter1 specifies the number to be rounded
'
' Parameter2: int32 or mode - 1. int32 specifies the number of fractional
' digits to be returned in the result. If
' there is no parameter2 or if it is mode,
' the result is rounded to a whole number.
' 2. mode - The mode parameter controls how
' value is rounded if the first decimal
' digit in value is 5
'
' Parameter3: mode - The mode parameter controls how value
' is rounded if the first decimal digit in value is 5
' There are two possible modes:
' 1. MidpointRounding.ToEven. If the one's digit
' is odd, it is changed to an even digit.
' Otherwise, it is left unchanged. This is
' often called rounding to nearest, or banker's
' rounding. It minimizes rounding errors that
' result from consistently rounding a midpoint
' value in a single direction.
' 2. MidpointRounding.AwayFromZero. The
' one's digit is always rounded up to the
' next digit.  This is the most popular
' rounding method.
'
' Result: decimal or double - depends on data type
' of parameter1. It is decimal, if parameter1 is
' decimal. If parameter1 is double, result is double.
'
' Quick Example: Round(3.5) ' Returns 4
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Round
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Round(decimal)"

        TextBox1.Text = String.Format("Round(3.5) = {0}", Round(3.5)) ' Returns 4


        Label2.Text = "Example #2: 	Round(double, mode)"
        Dim myDouble As Double = 6.5
        TextBox2.Text = String.Format("Round(myDouble, MidpointRounding.ToEven) = {0}", _
  Round(myDouble, MidpointRounding.ToEven)) ' Returns 6

        Label3.Text = "Example #3: 	Round(double, mode)"



        TextBox3.Text = String.Format("Round(myDouble, MidpointRounding.AwayFromZero) = {0}", _
         Round(myDouble, MidpointRounding.AwayFromZero)) ' Returns 7

    End Sub
End Class
