
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: Returns an integer indicating the sign of the
' input parameter. The result is -1 if the input
' parameter is less than one; 0 if the input is
' zero; and 1 if the input is > 0
'
' Syntax: 	1. Sign(decimal)
' 2. Sign(double)
' 3. Sign(int16)
' 4. Sign(int32)
' 5. Sign(int64)
' 6. Sign(SByte)
' 7. Sign(Single)
'
' Parameter1: decimal - Any valid System.Decimal data type number
' 2. double - any valid System.Double data type.
' 3. int16 - any valid System.Int16 data type.
' 4. int32 - any valid System.Int32 data type.
' 5. int64 - any valid System.Int64 data type.
' 6. SByte - any valid 8-bit SByte
' 7. Single - any valid single floating-point 32-bit number.
'
'
' Result: Int32 - Returns an integer indicating the sign of the
' input parameter. The result is -1 if the input
' parameter is less than one; 0 if the input is
' zero; and 1 if the input is > 0
'
' Quick Example: Sign(3.5) ' Returns 1
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Sign
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Sign(decimal)"

        TextBox1.Text = String.Format("Sign(3.5) = {0}", Sign(3.5)) ' Returns 1


        Label2.Text = "Example #2: 	Sign(double)"
        Dim myDouble As Double = -6.5
        TextBox2.Text = String.Format("Sign(myDouble) = {0}", Sign(myDouble)) ' Returns -1
		

        Label3.Text = "Example #3: 	Sign(int16)"
        Dim myInt16 As Int16 = 0


        TextBox3.Text = String.Format("Sign(myInt16) = {0}", Sign(myInt16)) ' Returns 0


    End Sub
End Class
