
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: converts an angle measured in radians to a tangent.  (you can convert
' the radians to degrees by multiplying them by Math.PI/180)
'
' Syntax: 	Tan(doublenumber)
'
' Parameter1: doublenumber - double percision floating point
' number representing an angle measured in radians.
'
' Result: double - represents the tangent of the angle specified in
' parameter1. If parameter1 is equal to NaN,
' NegativeInfinity,  or PositiveInfinity,
' NaN (Not a Number) is returned.
'
' Quick Example:  Tan(radians) ' Returns 0.449218546627416
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Tan
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Tan(doublenumber)"

        Dim radians As Double = 30 * 180 / Math.PI

        TextBox1.Text = String.Format("Tan(radians) = {0}", Tan(radians)) ' Returns 0.449218546627416


        Label2.Text = "Example #2: 	Tan(doublenumber)"

        radians = 90 * 180 / Math.PI

        TextBox2.Text = String.Format("Tan(radians) = {0}", Tan(radians)) ' Returns 3.18545051165583
		

        Label3.Text = "Example #3: 	Tan(doublenumber)"

        Dim Integer3 As Integer = Tan(-0)

        radians = 180 * 180 / Math.PI

        TextBox3.Text = String.Format("Tan(radians) = {0}", Tan(radians)) ' Returns -0.696494466235817


    End Sub
End Class
