
Imports System
Imports System.IO
Imports System.Data
Imports System.Math

'********************************************************************************
' Purpose: converts an angle measured in radians to a hyperbolic tangent.  (you can convert
' the radians to degrees by multiplying them by Math.PI/180)
'
' Syntax: 	Tanh(doublenumber)
'
' Parameter1: doublenumber - double percision floating point
' number representing an angle measured in radians.
'
' Result: double - represents the hyperbolic tangent of the angle specified in
' parameter1. If parameter1 is equal to NegativeInfinity,
' -1 is returned. If parameter1 is NaN,
' NaN (Not a Number) is returned. If parameter1
' is PositiveInfinity, +1 is returned.
'
' Quick Example: Tanh(30 * 180 / Math.PI) ' Returns 1
'
'********************************************************************************
' This example is from http://idealprogrammer.com



Partial Class _Tanh
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        Label1.Text = "Example #1: 	Tanh(doublenumber)"

        Dim radians As Double = 30 * 180 / Math.PI

        TextBox1.Text = String.Format("Tanh(radians) = {0}", Tanh(radians)) ' Returns 1


        Label2.Text = "Example #2: 	Tanh(doublenumber)"

        radians = -90 * 180 / Math.PI

        TextBox2.Text = String.Format("Tanh(radians) = {0}", Tanh(radians)) ' Returns -1
		

        Label3.Text = "Example #3: 	Tanh(doublenumber)"

        Dim Integer3 As Integer = Tanh(-0)

        radians = 180 * 180 / Math.PI

        TextBox3.Text = String.Format("Tanh(radians) = {0}", Tanh(radians)) ' Returns 1


    End Sub
End Class
