﻿Imports System.Text
Imports System
Imports System.Text.StringBuilder
Partial Class LanguageBasics_StringBuilder
    Inherits System.Web.UI.Page


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load


        '****************************************************************************************
        ' Example #1: StringBuilder Append(string) - most common way stringbuilder is used
        ' Adds the specified string or string representation of the specified value to the end 
        ' of the string
        '****************************************************************************************


        Dim sb As New StringBuilder

        Label1a.Text = "Example #1: Simple StringBuilder Append(string) "
        sb.Append("First Line")
        sb.Append("<br />")
        sb.Append("Second Line")

        Label1.Text = sb.ToString()


        'Append(string, startIndex, count)
        '****************************************************************************************
        ' Example #2: StringBuilder Append(string, startIndex, count) 
        ' Adds a substring of the specified string, starting with the specified
        ' position and having the specified length, to the end of the string
        '****************************************************************************************


        Dim sb2 As New StringBuilder
        Label2a.Text = "Example #2: StringBuilder Append(string, startIndex, count)"
        sb2.Append("The dog and cat ")
        sb2.Append("love to fight and play", 0, 13) 'take love to fight and add to end of prev string
        Label2.Text = sb2.ToString()

        

        'Insert(index, string[, count])
        '****************************************************************************************
        ' Example #3: StringBuilder Insert(index, string[, count]) 
        ' Inserts the specified string or a string representation of the specified
        ' value at the specified position in the string the specified number of 
        ' times. If the count is ommitted, a single copy of the string is inserted.
        '****************************************************************************************


        Dim sb3 As New StringBuilder
        Label3a.Text = "Example #3: Insert(index, string[, count])"

        sb3.Append("This is the initial sentence")
        sb3.Insert(20, "and modified ", 2)
        Label3.Text = sb3.ToString()

        

        'Remove(startIndex,count)
        '****************************************************************************************
        ' Example #4: StringBuilder Remove(startIndex,count) 
        ' Removes the specified number of characters from the string starting at
        ' the specified position
        '****************************************************************************************


        Dim sb4 As New StringBuilder
        Label4a.Text = "Example #4: StringBuilder Remove(startIndex,count)"

        sb4.Append("This is the initial sentence")
        sb4.Remove(20, 8)
        Label4.Text = sb4.ToString()

        

        'Replace(oldString,newString [,startIndex][,count])
        '****************************************************************************************
        ' Example #5: StringBuilder Replace(oldString,newString [,startIndex][,count])
        ' Replaces all occurences of the old string with the new string starting
        ' at the specified position and continuing for the specified number of characters.
        ' If you omit startIndex, it starts at beginning
        ' If you omit count, it does entire string
        '****************************************************************************************

        Dim sb5 As New StringBuilder
        Label5a.Text = "Example #5: StringBuilder Replace(oldString,newString [,startIndex][,count])"


        sb5.Append("This is the initial sentence")
        sb5.Replace("initial", "new")
        Label5.Text = sb5.ToString()

        

    End Sub
End Class

