﻿
Partial Class FormatDateTime
    Inherits System.Web.UI.Page



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        '**************************************************
        '        Custom DateTime Formatting
        '**************************************************
        Dim sb As New StringBuilder
        sb.Append("Custom DateTime Formatting:<br />")

        'Here are custom format specifiers y (year), M (month), d (day), h (hour 12), H (hour 24), m (minute), s (second),
        ' f (second fraction), F (second fraction, trailing zeroes are trimmed), t (P.M or A.M) and z (time zone).

        'Following examples show how the format specifiers can be used.
        ' create date time 2009-12-21 20:04:08.101
        Dim dt As New DateTime(2009, 12, 20, 20, 4, 8, _
         101)

        ' Ways to format year: "9 09 009 2009"   year
        sb.Append(String.Format("{0:y yy yyy yyyy}", dt) + "<br />")

        ' Ways to format month: "12 12 Dec December"  month
        sb.Append(String.Format("{0:M MM MMM MMMM}", dt) + "<br />")

        ' Ways to format day: "21 21 Sun Sunday" day
        sb.Append(String.Format("{0:d dd ddd dddd}", dt) + "<br />")

        ' Ways to format hour: "8 08 20 20"      hour 12/24
        sb.Append(String.Format("{0:h hh H HH}", dt) + "<br />")

        ' Ways to format minute: "4 04"            minute
        sb.Append(String.Format("{0:m mm}", dt) + "<br />")

        ' Ways to format second:  ' "8 08"            second 
        sb.Append(String.Format("{0:s ss}", dt) + "<br />")

        ' Ways to format fraction of second: "1 10 101 1010"   sec.fraction
        sb.Append(String.Format("{0:f ff fff ffff}", dt) + "<br />")

        ' Ways to format fraction of second: "1 1 101 101"   without zeros
        sb.Append(String.Format("{0:F FF FFF FFFF}", dt) + "<br />")

        ' How to display am or pm: "P PM"            A.M. or P.M.
        sb.Append(String.Format("{0:t tt}", dt) + "<br />")

        ' How to display timezone: "-6 -06 -06:00"   time zone
        sb.Append(String.Format("{0:z zz zzz}", dt) + "<br />")


        '**************************************************
        '        Using date separator / (slash) and time sepatator : (colon).
        '**************************************************
        sb.Append("<br />")
        sb.Append("Using date separator / (slash) and time sepatator : (colon):<br />")

        'These characters will be rewritten to characters defined 
        'in the current DateTimeFormatInfo.DateSeparator and DateTimeFormatInfo.TimeSeparator.


        ' "20/12/09 20:04:08" - english (en-US)
        sb.Append(String.Format("{0:d/M/yyyy HH:mm:ss}", dt) + "<br />")

        ' "20.12.2009 20:04:08" - german (de-DE)
        ' date separator in german culture is "." (so "/" changes to ".")
        sb.Append(String.Format("{0:d/M/yyyy HH:mm:ss}", dt) + "<br />")

        '**************************************************
        ' Here are some examples of custom date and time formatting:
        '**************************************************
        sb.Append("<br />")
        sb.Append("Here are some examples of custom date and time formatting:<br />")

        ' month/day numbers without/with leading zeroes
        ' "12/20/2009"
        sb.Append(String.Format("{0:M/d/yyyy}", dt) + "<br />")

        ' "12/20/2009"
        sb.Append(String.Format("{0:MM/dd/yyyy}", dt) + "<br />")

        ' day/month names
        ' "Sun, Dec 20, 2009"
        sb.Append(String.Format("{0:ddd, MMM d, yyyy}", dt) + "<br />")

        ' "Sunday, December 20, 2009"
        ' two/four digit year
        sb.Append(String.Format("{0:dddd, MMMM d, yyyy}", dt) + "<br />")

        ' "12/20/09"
        sb.Append(String.Format("{0:MM/dd/yy}", dt) + "<br />")

        ' "12/20/2009"
        sb.Append(String.Format("{0:MM/dd/yyyy}", dt) + "<br />")

        '**************************************************
        '        Standard DateTime Formatting
        '**************************************************
        sb.Append("<br />")
        sb.Append("Standard DateTime Formatting:<br />")
        'In DateTimeFormatInfo there are defined standard patterns for the current culture. 
        'For example, property ShortTimePattern is string that contains value h:mm tt for en-US culture 
        'and value HH:mm for de-DE culture.

        'Following table shows patterns defined in DateTimeFormatInfo and their values for en-US culture. 
        'First column contains format specifiers for the String.Format method.

        'Specifier DateTimeFormatInfo property Pattern value (for en-US culture) 
        't ShortTimePattern h:mm tt 
        'd ShortDatePattern M/d/yyyy 
        'T LongTimePattern h:mm:ss tt 
        'D LongDatePattern dddd, MMMM dd, yyyy 
        'f (combination of D and t) dddd, MMMM dd, yyyy h:mm tt 
        'F FullDateTimePattern dddd, MMMM dd, yyyy h:mm:ss tt 
        'g (combination of d and t) M/d/yyyy h:mm tt 
        'G (combination of d and T) M/d/yyyy h:mm:ss tt 
        'm, M MonthDayPattern MMMM dd 
        'y, Y YearMonthPattern MMMM, yyyy 
        'r, R RFC1123Pattern ddd, dd MMM yyyy HH':'mm':'ss 'GMT' (*) 
        's SortableDateTi­mePattern yyyy'-'MM'-'dd'T'HH':'mm':'ss (*) 
        'u UniversalSorta­bleDateTimePat­tern yyyy'-'MM'-'dd HH':'mm':'ss'Z' (*) 
        '    (*) = culture independent 

        'Following examples show usage of standard format specifiers in String.Format method and the resulting output.

        ' "8:04 PM"                         ShortTime
        sb.Append(String.Format("{0:t}", dt) + "<br />")

        ' "12/20/2009"                        ShortDate
        sb.Append(String.Format("{0:d}", dt) + "<br />")

        ' "8:04:08 PM"                      LongTime
        sb.Append(String.Format("{0:T}", dt) + "<br />")

        ' "Sunday, December 20, 2009"          LongDate
        sb.Append(String.Format("{0:D}", dt) + "<br />")

        ' "Sunday, December 20, 2009 8:04 PM"  LongDate+ShortTime
        sb.Append(String.Format("{0:f}", dt) + "<br />")

        ' "Sunday, December 20, 2009 8:04:08 PM" FullDateTime
        sb.Append(String.Format("{0:F}", dt) + "<br />")

        ' "12/20/2009 8:04 PM"                ShortDate+ShortTime
        sb.Append(String.Format("{0:g}", dt) + "<br />")

        ' "12/20/2009 8:04:08 PM"             ShortDate+LongTime
        sb.Append(String.Format("{0:G}", dt) + "<br />")

        ' "December 20"                        MonthDay
        sb.Append(String.Format("{0:m}", dt) + "<br />")

        ' "December, 2009"                     YearMonth
        sb.Append(String.Format("{0:y}", dt) + "<br />")

        ' "Sun, 20 Dec 2009 20:04:08 GMT"   
        sb.Append(String.Format("{0:r}", dt) + "<br />")

        ' "2009-12-20T20:04:08"             SortableDateTime
        sb.Append(String.Format("{0:s}", dt) + "<br />")

        ' "2009-12-20 20:04:08Z"            UniversalSortableDateTime
        sb.Append(String.Format("{0:u}", dt) + "<br />")

        Label1.Text = sb.ToString





    End Sub
End Class
