/** =================================================
 **                License Statement
 ** =================================================
 * 
 ** Copyright (c) 2014-2022 David Winterburn <info@fwsentry.org>.
 * 
 ** This file contains Original Code of the author, and is subject to the license
 ** terms below. In brief, using current terminology, this is a permissive license
 ** modelled on the 3-clause BSD License. 
 * 
 ** Permission to use, copy, modify, and distribute this software for any purpose
 ** is hereby granted as long as such purposes do not violate the terms of this 
 ** license, and provided that the above copyright notice and this permission 
 ** notice and license appear unmodified in ALL copies, distributed or stored. 
 ** All intellectual property and patent rights remain with the author.
 * 
 ** THE ORIGINAL CODE AND ALL SOFTWARE DISTRIBUTED UNDER THIS LICENSE IS PROVIDED
 ** ON AN "AS IS" BASIS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
 ** AND THE AUTHOR DISCLAIMS ALL SUCH WARRANTIES, OR LEGAL CLAIMS, WITH REGARD TO
 ** THIS SOFTWARE INCLUDING WITHOUT LIMITATION ANY WARRANTIES, IMPLIED OR OTHER,
 ** OF MERCHANTABILITY, PERFORMANCE AND FITNESS FOR A PARTICULAR PURPOSE, QUIET
 ** ENJOYMENT OR NON-INFRINGEMENT. UNDER NO CIRCUMSTANCES SHALL THE AUTHOR BE IN
 ** ANY WAY LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES, OR
 ** ANY DAMAGES WHATSOEVER, RESULTING FROM THE USE OF THIS SOFTWARE. SUCH DAMAGES
 ** MAY INCLUDE, BUT ARE NOT LIMITED TO, LOSS OF USE, EQUIPMENT, DATA, BILLABLE
 ** TIME, PERSONAL OR PHYSICAL INJURY, AND DIRECT OR INDIRECT PROFITS, WHETHER IN
 ** AN ACTION OF CONTRACT, NEGLIGENCE OR ANY OTHER TORTIOUS ACTION, ARISING OUT
 ** OF, OR IN CONNECTION WITH, THE USE OF, THE FITNESS OR PERFORMANCE OF THIS
 ** SOFTWARE, UNDER ANY CIRCUMSTANCES. THIS SOFTWARE WAS NOT DESIGNED TO BE USED
 ** IN ANY SITUATION WHERE HUMAN LIFE IS AT RISK, AND NO SUCH USE IS PROVIDED FOR
 ** OR PERMITTED.
 * 
 ** BY USING THIS SOFTWARE YOU AGREE THAT IT IS THE SOLE RESPONSIBILITY OF THE END
 ** USER TO DECIDE IF THIS SOFTWARE OR PACKAGE PERFORMS, OR IS FIT FOR, ANY
 ** INTENDED USAGE.
 * 
 ** This License and the rights granted hereunder will terminate; automatically
 ** without notice from the Author if You fail to comply with any term(s) of this
 ** License and fail to cure such breach within 30 days of becoming aware of such
 ** breach; or automatically without notice from the Author if You, at any time
 ** during the term of this License, commence any legal action against the Author.
 ** Upon termination of the license you are required to remove all copies of this
 ** software from all computer systems and data storage archives under your
 ** jurisdiction or control.
 * 
 ** This license is automatically extended, if in the future, the Author exercises
 ** any intellectual property, or patent, rights connected with any of the Original
 ** Code included in this package. ALL end users using this package within the terms
 ** of this license, will automatically licensed to use those exercised or covered 
 ** claims free of charge as they apply to this software package.
 **/



/*	D-List version 1.2 -- Copyright (c) 2014-2022 David Winterburn <info@fwsentry.org>	*/



/* **********************************************************************
**																		**
**			Header for definitions, types and structs for the			**
**			internal use of D-list ONLY. Private - not for 				**
**					use outside of D-list internals.					**
**																		**	
**		Dlist users do not need to include this header file, it			**	
**		is already included in dlist.h. This allows the internal		**	
**		details of dlist to be abstracted away from its usage.			**	
**																		**	
 ************************************************************************ */
 
#ifndef DLIST_INTERNAL_H
#define DLIST_INTERNAL_H

#ifdef __cplusplus
extern "C" {
#endif


/*	=====================================================================
		Section - Definitions for all D-List types
	=====================================================================	*/


#define HEAD_GUARD						1
#define TAIL_GUARD						1

#define LEAF_ADDED						0
#define LEAF_REMOVED					1

#define LIST_WRITE						TRUE

/* The leaf node is split into 2 separate parts, that are functionally one 
	thing. Due to the way x86 processors load memory and the gcc compiler 
	prefetches structs, if the leaf node exceeds 32 bytes it will cause a 
	dramatic slow down of repeated operations, especially those that walk 
	the leaf node chain, such as searches etc. 										*/

/* Leaf node internals */
typedef struct {
	void *master;							/* NULL = free node, or list we belong to - for validation, and list audit */
#ifndef DLIST_USE_MALLOC
	void *leaf_block;						/* The list leaf block we belong to - for audit, and efficient resource releases */
	void *next_freep;						/* The next free leaf node in the free list, of this list, NULL if it is the last one, or if leaf node in use */
#endif	/* ! DLIST_USE_MALLOC */
	union pivot_padding_u {
		int value;							/* 0 == no pivot, <0 less than (minor to), or >0 greater than (major to) pivot point */
#ifndef DLIST_USE_MALLOC
		void *filler;						/* NEVER used, here to enforce correct padding and boundaries for allocating these leaf nodes en-masse */
#endif	/* ! DLIST_USE_MALLOC */
	} pivot;

} leaf_node_data;

/* Leaf node */
struct leaf_node__s {
	struct leaf_node__s *next_leaf;			/* The next occupied leaf node in this list - NULL if free */
	struct leaf_node__s *prior_leaf;		/* The previous occupied leaf node in this list - NULL if free */
	leaf_node_data *internal;				/* internal data for this leaf node, see above... */
	void *element;							/* The users actual element we are keeping track of */
};
typedef struct leaf_node__s leaf_node;

/* This leaf node allocation system uses chained blocks of leaf nodes that are
	allocated as needed, and released when not. 
	
	It uses a simple and efficient free list based system, the allocation
	count (nodes_in_use) is only used to decide which blocks to free when 
	needed. Originally it was in place to support auditing and debugging
	but now the code is stable and bug free it is no longer in use. The 
	same applies to block number, it will be removed in a later release
	and is also deprecated. To be removed in v1.1.
	
	For purposes of freep and block maintenance the block address is used. For
	integrity checking and reference validation the master pointer is used.			*/

/*	ONLY RELEVANT FOR NORMAL COMPILES 
	
	if you compile with DLIST_USE_MALLOC, this info is irrelevant 
	
	For the default condition (no list size hints provided at list_create()
	
	With extensive performance testing on 64 bit system, i settled on 1000 
	as the best overall number that does not waste a lot of space, but yields 
	the best performance boosts. 
	
	This is the value used if you do not specify a size hint when you create 
	a new list. Generally if you have some idea of the scale of the list you 
	need specify a size hint ! it is far more efficient. Especially for lists 
	in the hundreds of thousands or millions, or ones that are very small.
	
	IF you are running code with DEBUG_DLIST defined (which you should only
	do if you really must and are developing internal D-List code), then use 
	a size hint on list_create that does not leave a lot of free leaf nodes. 
	If there are large numbers of free leaf nodes list_audit() will be 
	painfully slow. 
	
	Normally nobody but the author would want to use DEBUG_DLIST anyway.
	
	Also in general nobody should need to twiddle with this define. 
	
	****	Please use the list size hints instead	**** 							*/
#ifndef LEAF_NODE_ARRAY_SIZE
#define LEAF_NODE_ARRAY_SIZE			1000
#endif


#ifndef DLIST_USE_MALLOC

typedef struct {
	void *master;							/* The list we belong to - for validation, and list audit */
	leaf_node_data leaf_nodes_data[];		/* The actual leaf node internal data array for this block */
} leaf_node_internals;

struct leaf_node_array__s {
	void *master;							/* The list we belong to - for validation, and list audit */
	struct leaf_node_array__s *next_block;	/* NULL == last (first allocated) block, next leaf node block */
	leaf_node_internals *internals;			/* pointer to internals block for this leaf node block */
	int block_number;						/* deprecated - assignment block number, (order in the reverse list) */
	int nodes_allocated;					/* total number of leaf nodes allocated with this block */
	int nodes_in_use;						/* deprecated - number of leaf nodes assigned to user elements, in this block */
	leaf_node leaf_nodes[];					/* The actual leaf node array for this block */
};
typedef struct leaf_node_array__s leaf_node_array;



#endif	/* ! DLIST_USE_MALLOC */

/* List functions */
typedef struct {
	element_compare compare;
	element_pivot pivot;
	element_search search;
	element_size size;
	element_iterate iterate;
	element_insert insert;
	element_remove remove;
#ifdef DLIST_STREAMS
/* all functions and types related to save and restore are only described. 
	They may or may not be implemented at a later date								*/
	element_save_out save_out;
	element_restore restore;
#endif	/* DLIST_STREAMS */
} dlist_functions;

/* List master node */
typedef struct {
#ifndef DLIST_USE_MALLOC
	leaf_node_array *leaf_block;			/* blocks of memory set-aside for leaf nodes */
	leaf_node *freep;						/* The free list of leaf nodes for this list object */
#endif	/* ! DLIST_USE_MALLOC */
	leaf_node *head_guard;					/* The list will always have 2 internal only elements */
	leaf_node *tail_guard;
	leaf_node *mid_point;					/* optimize elements by index (always correct), nullified if list updated by reference */
	leaf_node *iteration_point;				/* while iterating, the current element returned or NULL*/
	dlist_functions functions;				/* pointers to users list operation functions */
	unsigned int element_count;				/* total user elements stored in list */
	unsigned int max_element_count;			/* maximum number of user elements allowed in list (finite list only) */
#ifndef DLIST_USE_MALLOC
	unsigned int allocation_size;			/* number of leaf nodes to allocate in each leaf_node_array block */
#endif	/* ! DLIST_USE_MALLOC */
	struct {								/* For a pivot list, minor + major == element_count, else == 0 */
		unsigned int minor;					/* total elements stored on minor side of pivot (pivot list only) */
		unsigned int major;					/* total elements stored on major side of pivot (pivot list only) */
	} pivot_point;
	boolean iteration_enabled;				/* TRUE iteration started. List index modifications are blocked */
	boolean iteration_direction;			/* TRUE forward (head to tail) FALSE opposite */
	boolean list_sorted;					/* TRUE list is in a sorted state */
	boolean sorted_order;					/* TRUE LIST_ASCENDING (smaller to larger) FALSE LIST_DESCENDING */
	boolean list_manages_elements;			/* FALSE user creates and frees elements, TRUE D-List does it */
	boolean list_pivot_enabled;				/* FALSE normal list, TRUE pivot class list */
	boolean list_finite_enabled;			/* FALSE normal list, TRUE finite class list */
} list_object;

/* This can change between releases, DO NOT make assumptions about what this
	is under the covers. Treat it as an opaque object, that is why it was
	typedef'ed in the first place.													*/
typedef leaf_node element_reference;


/*	=====================================================================
		Section - Definitions for Hashed D-Lists only
	=====================================================================	*/


typedef struct {
	void *master;							/* hashed_list_object we belong to (really filler to allow the flexible array member below) */
	list_object *list_bucket[];				/* index of pointers to list_objects of the addr list */
} hash_list_index;

/* Hashed List functions */
typedef struct  {
	element_hash hash;						/* pointer to mandatory hash function for this list */
	element_compare compare;
	element_search search;
	element_size size;
	element_iterate iterate;
	element_insert insert;
	element_remove remove;
} hash_list_functions;

/* all list attributes defined here in hashed_list_object, apply to all bucket lists created under it -- No mixed modes */
typedef struct {
	hash_list_index *index;					/* index of list_objects of the hashed list, 0 -> hash_size-1 */
	hash_list_functions functions;			/* pointers to users list operation functions */
	unsigned int hash_size;					/* total number of possible list hashes, & total number of potential list buckets  */
	unsigned int iteration_index;			/* current bucket being iterated */
	unsigned int size_hint;					/* size hint, to pass on for each bucket list */
	boolean iteration_enabled;				/* TRUE iteration started. list modifications are blocked */
	boolean bucket_iteration_enabled;		/* TRUE iteration in progress for the bucket -> iteration_index */
	boolean list_sorted;					/* TRUE list is in a (sort of) sorted state */
	boolean sorted_order;					/* TRUE LIST_ASCENDING (smaller to larger) FALSE LIST_DESCENDING */
	boolean list_manages_elements;			/* FALSE user creates and frees elements, TRUE D-List does it */
} hash_list_object;

/* This can change between releases, DO NOT make assumptions about what this
	is under the covers. Treat it as an opaque object, that is why it was
	typedef'ed in the first place.													*/
typedef struct {
	unsigned int hash;
	element_reference *leaf_node;
} hash_element_reference;


#ifdef __cplusplus
}
#endif		/* __cplusplus */

#endif		/* DLIST_INTERNAL_H */